package cn.com.duiba.quanyi.center.api.remoteservice.ali.travel;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.ali.travel.AliTravelActivityRecordDto;
import cn.com.duiba.quanyi.center.api.param.ali.travel.AliTravelActivityRecordSearchParam;
import java.util.List;

/**
 * 支付宝旅行活动用户领取记录表
 * @author kjj mybatis generator 
 * @date 2024-04-30
 */
@AdvancedFeignClient
public interface RemoteAliTravelActivityRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 支付宝旅行活动用户领取记录集合
     */
    List<AliTravelActivityRecordDto> selectPage(AliTravelActivityRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(AliTravelActivityRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 支付宝旅行活动用户领取记录
     */
    AliTravelActivityRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 支付宝旅行活动用户领取记录
     * @return 执行结果
     */
    int insert(AliTravelActivityRecordDto dto);

    /**
     * 更新
     * @param dto 支付宝旅行活动用户领取记录
     * @return 影响行数
     */
    int update(AliTravelActivityRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}