package cn.com.duiba.quanyi.center.api.remoteservice.pkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.pkg.GoodsPkgOrderRecordDto;

import java.util.List;

/**
 * 商品包订单记录
 * @author lizhi
 * @date 2023/9/21 11:39
 */
@AdvancedFeignClient
public interface RemoteGoodsPkgOrderRecordService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品包订单记录
     */
    GoodsPkgOrderRecordDto selectById(Long id);

    /**
     * C端-分页查询
     * @param userId 用户ID
     * @param goodsPkgId 商品包ID
     * @param lastId 上次最后一个ID，第一页为null
     * @param pageSize 需要拉去的条数
     * @return 商品包订单记录
     */
    List<GoodsPkgOrderRecordDto> selectUserList(Long userId, Long goodsPkgId, Long lastId, Integer pageSize);

    /**
     * C端-分页查询
     * @param userId 用户ID
     * @param goodsPkgId 商品包ID
     * @return 商品包skuId
     */
    List<Long> selectPkgSkuIdListByUserPkg(Long userId, Long goodsPkgId);
}
