package cn.com.duiba.quanyi.center.api.remoteservice.sxgh;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.sxgh.BillSxghActDto;
import cn.com.duiba.quanyi.center.api.param.sxgh.BillSxghActSearchParam;

import java.util.List;

/**
 * 山西工行活动表
 *
 * @author kjj mybatis generator
 * @date 2024-04-18
 */
@AdvancedFeignClient
public interface RemoteBillSxghActService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 山西工行活动集合
     */
    List<BillSxghActDto> selectPage(BillSxghActSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(BillSxghActSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 山西工行活动
     */
    BillSxghActDto selectById(Long id);

    /**
     * 批量添加
     *
     * @param dtoList dtoList
     * @return 影响行数
     */
    int batchInsert(List<BillSxghActDto> dtoList);

    /**
     * 根据活动ID批量查询
     *
     * @param activityIds 活动ID集合
     * @return 山西工行活动集合
     */
    List<BillSxghActDto> selectByActivityIds(List<String> activityIds);
}