package cn.com.duiba.quanyi.center.api.dto.activity;

import cn.com.duiba.quanyi.center.api.enums.activity.ActivityDrawLimitCycleEnum;
import cn.com.duiba.quanyi.center.api.enums.activity.ActivityLimitConfigEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 活动限制扩展表
 * @author mybatis generator 
 * @date 2023-12-15
 */
@Data
public class ActivityLimitConfigDto implements Serializable {

    private static final long serialVersionUID = 5419581465245690190L;

    /**
     * 领取周期限制开关
     * @see ActivityDrawLimitCycleEnum
     */
    private Integer drawLimitType;

    /**
     * 日开始时间
     * 时间格式 HHmm
     * 默认有值
     */
    private Long dayStartTime;

    /**
     * 日结束时间
     * 时间格式 HHmm
     * 默认有值
     */
    private Long dayEndTime;

    /**
     * 周限制时间，格式为 1,2,3,4,5,6,7
     * 1表示周一，7表示周日
     * 多个值用逗号分隔
     * 周限制和月限制互斥
     */
    private String weekLimitByDay;

    /**
     * 月限制开始时间
     * 时间格式 dd
     */
    private Integer monthStartTimeByDay;

    /**
     * 月限制结束时间
     * 时间格式 dd
     */
    private Integer monthEndTime;

    /**
     * 领取限制配置
     */
    private List<ActivityDrawLimitConfigDto> drawLimitConfigDtoList;
}