package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/4/17 15:07
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CouponFullAutoCreateExtInfoDto extends WxCouponAutoCreateExtInfoDto {
    private static final long serialVersionUID = 8567206157621351013L;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 活动名称
     */
    private String batchName;

    /**
     * 活动开始时间
     */
    private String beginTime;

    /**
     * 活动结束时间
     */
    private String endTime;

    /**
     * 活动描述
     */
    private String description;

    /**
     * 每人领取数量
     */
    private Integer everyoneNum;

    /**
     * 商品编码列表
     */
    private List<String> skuCodeList;

    /**
     * 是否插入微信
     */
    private Integer insertToWx;

    /**
     * 主题色
     */
    private Integer themeColor;

    /**
     * 是否允许同时使用
     */
    private Integer canUseBoth;

    /**
     * 券生效时间 1-立刻 2-第二天生效
     */
    private Integer couponValidType;

    /**
     * 品牌名称
     */
    private String brandName;

    /**
     * 品牌logo
     */
    private String brandLogo;

    /**
     * 跳转类型 0-默认页 1-付款码
     */
    private Integer jumpType;

    /**
     * 指定支付方式 0-不限 1-银行卡 2-零钱
     */
    private Integer directPayMethod;

    /**
     * 支付方式
     * {@link cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.WxCouponPaySceneEnum}
     */
    private List<Integer> payScene;

    /**
     * 卡类型 1-储蓄卡 2-信用卡
     */
    private Integer cardType;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 卡bin列表
     */
    private List<String> cardBinList;

    /**
     * 卡bin描述
     */
    private Integer cardBinDesc;

    /**
     * 发放总上限
     */
    private Integer maxNum;

    /**
     * 每日发放总上限
     */
    private Integer dailyMaxNum;

    /**
     * 面额
     */
    private String batchAmount;

    /**
     * 门槛
     */
    private String orderRequire;

    /**
     * 有效日期段 1-全部 2-有效期内，用户领券后x天 3-有效期内，规则日期可用 4-有效期内 不规则日期可用
     */
    private Integer validPeriodType;

    /**
     * 有效期内，用户领券后x天内有效
     */
    private Integer validDay;

    /**
     * 规则日期可用内 星期选择 格式 [1,1,1,1,1,1,1] 1选中，0不选中
     */
    private List<Integer> validWeekDay;

    /**
     * 规则日期和不规则日期的单日时间段 格式：00:00-18:00
     */
    private List<String> validTimePeriod;

    /**
     * 不规则日期的日期选择 格式：2024-04-15&2024-04-17
     */
    private List<String> validTimeRange;

    /**
     * 立减金实际发放周期（天）
     */
    private Integer stockDistributePeriod;

    /**
     * 自然人防刷1-开启 2-关闭
     */
    private Integer natural;

    /**
     * 防小号1-开启 2-关闭
     */
    private Integer spam;

    /**
     * 其他可发券商户
     */
    private List<String> otherMerchantCodeList;

    /**
     * 活动商户
     */
    private List<String> activityMerchantCodeList;
}
