package cn.com.duiba.quanyi.center.api.enums.ccb;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author nongfu
 * @Date 2024/4/9 18:03
 */
@Getter
public enum BankTypeEnum {

    POSTAL_SAVINGS_CARD("01", "储蓄卡"),
    CREDIT_CARD("02", "信用卡");

    private final String bankType;

    private final String desc;


    BankTypeEnum(String bankType, String desc) {
        this.bankType = bankType;
        this.desc = desc;
    }


    private static final Map<String, BankTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BankTypeEnum::getBankType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     *
     * @param bankType 枚举值
     * @return 枚举
     */
    public static BankTypeEnum getByType(String bankType) {
        if (StringUtils.isBlank(bankType)) {
            return null;
        }
        return ENUM_MAP.get(bankType);
    }
}
