package cn.com.duiba.quanyi.center.api.param.pay.ext;

import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 支付宝支付
 * @author lizhi
 * @date 2023/10/22 11:20
 */
@Data
public class AlipayCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = -8761772655694590598L;

    /**
     * 对一笔交易的具体描述信息。如果是多种商品，请将商品描述字符串累加传给body
     */
    @NotNull(message = "支付描述不能为空")
    @Size(max = 128, message = "支付描述长度超过128")
    private String body;

    /**
     * 商品的标题/交易标题/订单标题/订单关键字等
     */
    @NotNull(message = "商品标题不能为空")
    @Size(max = 256, message = "商品标题长度超过256")
    private String subject;
}
