package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponAutoAddMoneyTaskDto;
import cn.com.duiba.quanyi.center.api.dto.coupon.WxCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.notify.WxCouponAddMoneyResultNotifyParam;

import java.util.List;

/**
 * 微信立减金加款任务结果通知
 * @author kjj mybatis generator 
 * @date 2024-03-19
 */
@AdvancedFeignClient
public interface RemoteWxCouponAddMoneyTaskService {

    /**
     * 任务结果通知
     *
     * @param notifyParams 通知参数
     */
    void taskResultNotify(List<WxCouponAddMoneyResultNotifyParam> notifyParams);

    /**
     * 查询需要加款的任务
     * @param size 数据
     * @return 任务集合
     */
    List<WxCouponAutoAddMoneyTaskDto> selectAddMoneyTaskList(Integer size);

    /**
     * 手动添加加款任务
     *
     * @param wxCoupon 微信立减金
     * @param amount 加款后金额
     * @return true-成功 false-失败
     */
    boolean createAddMoneyTask(WxCouponDto wxCoupon, Long amount);
}