package cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/3/25 15:54
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CouponBankAutoCreateExtInfoDto extends WxCouponAutoCreateExtInfoDto {
    private static final long serialVersionUID = -1758978705889443840L;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡类型 1-借记卡 2-信用卡
     */
    private Integer bankCardType;

    /**
     * 卡片名称
     */
    private String bankCardName;

    /**
     * 卡bin号列表
     */
    private List<String> cardBinList;

    /**
     * 主题色
     */
    private Integer themeColor;

    /**
     * 满减条件金额（元）
     */
    private String discountMax;

    /**
     * 满减金额（元）
     */
    private String discountAmount;

    /**
     * 开始日期 yyyy-MM-dd
     */
    private String startDate;

    /**
     * 结束日期 yyyy-MM-dd
     */
    private String endDate;

    /**
     * 领券后几天内可用 可用天数必须小于等于券有效期，不传表示有效期内任意时间可用
     */
    private Integer canUseDay;

    /**
     * 使用规则
     */
    private String useRule;

    /**
     * 同时使用 1-叠加使用 2-互斥试用
     */
    private Integer bothUse;

    /**
     * 单日发放上限金额（元）
     */
    private String dayLimitAmount;

    /**
     * 单用户领取上限
     */
    private Integer userReceiveTimes;

    /**
     * 发放方类型 1-仅本商户号 2-本商户号或其他商户号
     */
    private Integer senderType;

    /**
     * 其他商户号
     */
    private String otherMchId;

    /**
     * 是否开启自然人防刷 1-开启 2-关闭
     */
    private Integer useNaturalDefense;

    /**
     * 是否开启小号防刷 1-开启 2-关闭
     */
    private Integer useSpamBlock;

    /**
     * 立减金实际发放周期（天）
     */
    private Integer stockDistributePeriod;

    /**
     * 实际金额
     */
    private Long totalAmount;
}
