/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.wxcoupon;

import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.DiscountAmountRuleDto;
import cn.com.duiba.quanyi.center.api.utils.PriceUtils;
import cn.com.duiba.quanyi.center.api.utils.StringUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCouponAutoCreateUtils {
    private static final Logger log = LoggerFactory.getLogger(WxCouponAutoCreateUtils.class);

    public static Long calTotalAmount(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod) {
        long twoWeeksAmount = budgetAmount / (long)WxCouponAutoCreateUtils.calDiffDays(startDate, endDate, stockDistributePeriod).intValue() * 14L;
        twoWeeksAmount += couponAmount - twoWeeksAmount % couponAmount;
        return Math.min(Math.max(twoWeeksAmount, 10L * couponAmount), budgetAmount);
    }

    public static Integer calMaxNum(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod) {
        Long totalAmount = WxCouponAutoCreateUtils.calTotalAmount(budgetAmount, couponAmount, startDate, endDate, stockDistributePeriod);
        return Math.toIntExact((long)totalAmount.intValue() / couponAmount);
    }

    private static Integer calDiffDays(String startDate, String endDate, Integer stockDistributePeriod) {
        if (stockDistributePeriod != null) {
            return stockDistributePeriod;
        }
        return DateUtils.daysBetween((Date)DateUtils.getDayDate((String)startDate), (Date)DateUtils.getDayDate((String)endDate)) + 1;
    }

    public static boolean isValidStockName(String stockName) {
        return stockName != null && WxCouponAutoCreateUtils.strLength(stockName) <= 18;
    }

    private static int strLength(@NotBlank String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static boolean oneOrTwo(Integer num) {
        return num != null && (num == 1 || num == 2);
    }

    public static boolean zeroOrOne(Integer num) {
        return num != null && (num == 0 || num == 1);
    }

    public static boolean isValidThemeColor(Integer themeColor) {
        return themeColor != null && themeColor >= 1 && themeColor <= 10;
    }

    public static boolean isValidCardBin(@NotBlank String cardBinList) {
        List<String> cardBins = StringUtil.splitStringWithComma(cardBinList);
        if (cardBins.size() > 100) {
            return false;
        }
        for (String cardBin : cardBins) {
            if (cardBin.length() >= 6 && cardBin.length() <= 13) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBudgetAmount(String budgetAmount, Long discountAmount) {
        if (StringUtils.isBlank((CharSequence)budgetAmount)) {
            return false;
        }
        Long budget = PriceUtils.convertY2F(budgetAmount);
        return budget % discountAmount == 0L;
    }

    public static List<DiscountAmountRuleDto> parseDiscountAmountRules(String discountAmountRules) {
        if (StringUtils.isBlank((CharSequence)discountAmountRules)) {
            return null;
        }
        List<String> ruleStrList = StringUtil.splitStringWithComma(discountAmountRules);
        return ruleStrList.stream().map(ruleStr -> {
            DiscountAmountRuleDto dto = new DiscountAmountRuleDto();
            String[] ruleArr = ruleStr.split("&");
            if (ruleArr.length != 2) {
                log.info("parseDiscountAmountRules not valid ruleStr={}", ruleStr);
                return null;
            }
            dto.setAmount(ruleArr[0]);
            String[] rangeArr = ruleArr[1].split("-");
            if (rangeArr.length != 2) {
                log.info("parseDiscountAmountRules not valid rangeArr={}", (Object)ruleArr[1]);
                return null;
            }
            dto.setStartRange(rangeArr[0]);
            dto.setEndRange(rangeArr[1]);
            return dto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isValidDiscountAmountRules(String discountAmountRules) {
        List<DiscountAmountRuleDto> ruleList = WxCouponAutoCreateUtils.parseDiscountAmountRules(discountAmountRules);
        if (CollectionUtils.isEmpty(ruleList) || ruleList.size() > 5) {
            log.info("isValidDiscountAmountRules not valid ruleList size is empty or more then 5 discountAmountRules={}", (Object)discountAmountRules);
            return false;
        }
        try {
            long totalNum = 0L;
            for (DiscountAmountRuleDto rule : ruleList) {
                if (StringUtils.isBlank((CharSequence)rule.getAmount()) || StringUtils.isBlank((CharSequence)rule.getStartRange()) || StringUtils.isBlank((CharSequence)rule.getEndRange())) {
                    return false;
                }
                long amount = PriceUtils.convertY2F(rule.getAmount());
                Long startRange = PriceUtils.convertY2F(rule.getStartRange());
                Long endRange = PriceUtils.convertY2F(rule.getEndRange());
                if (amount <= 0L || startRange <= 0L || endRange <= 0L || endRange <= startRange || endRange >= amount) {
                    log.info("isValidDiscountAmountRules not valid amount startRange endRange is not valid discountAmountRule={}", (Object)JSON.toJSONString((Object)rule));
                    return false;
                }
                totalNum += amount / ((startRange + endRange) / 2L);
            }
            return totalNum >= 5L;
        }
        catch (Exception e) {
            log.error("isValidDiscountAmountRules discountAmountRules={}", (Object)discountAmountRules, (Object)e);
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(WxCouponAutoCreateUtils.isValidDiscountAmountRules("10&1-10,10&1-5"));
    }
}

