/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.wxcoupon;

import cn.com.duiba.quanyi.center.api.utils.PriceUtils;
import cn.com.duiba.quanyi.center.api.utils.StringUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;

public class WxCouponAutoCreateUtils {
    public static Long calTotalAmount(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod) {
        long twoWeeksAmount = budgetAmount / (long)WxCouponAutoCreateUtils.calDiffDays(startDate, endDate, stockDistributePeriod).intValue() * 14L;
        twoWeeksAmount += couponAmount - twoWeeksAmount % couponAmount;
        return Math.min(Math.max(twoWeeksAmount, 10L * couponAmount), budgetAmount);
    }

    public static Integer calMaxNum(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod) {
        Long totalAmount = WxCouponAutoCreateUtils.calTotalAmount(budgetAmount, couponAmount, startDate, endDate, stockDistributePeriod);
        return Math.toIntExact((long)totalAmount.intValue() / couponAmount);
    }

    private static Integer calDiffDays(String startDate, String endDate, Integer stockDistributePeriod) {
        if (stockDistributePeriod != null) {
            return stockDistributePeriod;
        }
        return DateUtils.daysBetween((Date)DateUtils.getDayDate((String)startDate), (Date)DateUtils.getDayDate((String)endDate)) + 1;
    }

    public static boolean isValidStockName(String stockName) {
        return stockName != null && WxCouponAutoCreateUtils.strLength(stockName) <= 18;
    }

    private static int strLength(@NotBlank String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static boolean oneOrTwo(Integer num) {
        return num != null && (num == 1 || num == 2);
    }

    public static boolean zeroOrOne(Integer num) {
        return num != null && (num == 0 || num == 1);
    }

    public static boolean isValidThemeColor(Integer themeColor) {
        return themeColor != null && themeColor >= 1 && themeColor <= 10;
    }

    public static boolean isValidCardBin(@NotBlank String cardBinList) {
        List<String> cardBins = StringUtil.splitStringWithComma(cardBinList);
        if (cardBins.size() > 100) {
            return false;
        }
        for (String cardBin : cardBins) {
            if (cardBin.length() >= 6 && cardBin.length() <= 13) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBudgetAmount(String budgetAmount, Long discountAmount) {
        if (StringUtils.isBlank((CharSequence)budgetAmount)) {
            return false;
        }
        Long budget = PriceUtils.convertY2F(budgetAmount);
        return budget % discountAmount == 0L;
    }
}

