package cn.com.duiba.quanyi.center.api.dto.ems.snsshop;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户扩展信息-邮储智慧校园
 * @author mybatis generator 
 * @date 2024-05-23
 */
@Data
public class EmsSnsShopUserExtDto implements Serializable {
     
    private static final long serialVersionUID = 17164525679293607L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 用户ID
     */
    private String uid;

    /**
     * 用户类型
     */
    private Integer userType;

    /**
     * 学生姓名
     */
    private String studentName;

    /**
     * 班级ID
     */
    private String classId;

    /**
     * 学校ID
     */
    private String schoolId;

    /**
     * 学校名称
     */
    private String schoolName;

    /**
     * 教育局ID
     */
    private String merchantId;

    /**
     * 教育局名称
     */
    private String merchantName;

    /**
     * 操作人ID
     */
    private String adminId;

    /**
     * 操作人电话号码
     */
    private String adminMobile;

    /**
     * 姓名
     */
    private String adminName;

    /**
     * 是否管理员: 1超级管理员，2普通账号，3普通管理员
     */
    private Integer isAdmin;

    /**
     * 类型：0 教育局 1学校 2家长 3老师
     */
    private Integer type;

    /**
     * 手机号
     */
    private String uidMobile;

    /**
     * 客户端ID
     */
    private String clientId;

    /**
     * 客户端类型: 1 微信小程序;2 银行app
     */
    private Integer clientType;

    /**
     * 类型
     */
    private Integer thirdType;

    /**
     * 学生与家长关系: 1,爸爸 2,妈妈 3,其他监护人, 4本人
     */
    private Integer parentType;

    /**
     * 手机端绑定用户ID
     */
    private String selfUid;

    /**
     * 家长(监护人)ID
     */
    private String parentId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}