package cn.com.duiba.quanyi.center.api.param.coupon.notify;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/3/19 20:55
 **/
@Data
public class WxCouponAddMoneyResultNotifyParam implements Serializable {
    private static final long serialVersionUID = -6865501808297257005L;

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String mchCode;

    /**
     * 任务id
     */
    @NotNull(message = "任务id不能为空")
    private Long taskId;

    /**
     * 批次id
     */
    @NotNull(message = "batchId不能为空")
    private String batchId;

    /**
     * 加款后金额
     */
    @NotNull(message = "amount不能为空")
    private String amount;

    /**
     * 2-成功 3-失败
     */
    @NotNull(message = "result不能为空")
    private Integer result;

    /**
     * 加款失败原因
     */
    private String errorMsg;
}
