package cn.com.duiba.quanyi.center.api.dto.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝立减金表
 *
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
public class AlipayActivityDto implements Serializable {

    private static final long serialVersionUID = 16953666713952389L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝分配给开发者的应用ID
     */
    private String alipayAppId;

    /**
     * 支付宝活动后台类型，1-银行卡支付立减;2-通用渠道红包;3-首绑有礼;4-多刷有礼
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTypeEnum
     */
    private Integer alipayActType;

    /**
     * 支付宝活动ID
     */
    private String alipayActId;

    /**
     * 支付宝活动名称
     */
    private String alipayActName;

    /**
     * 支付宝活动状态,CREATED="已创建",PUBLISHING="发布中",PUBLISHED_FAILED="发布失败",GREY="已发布(白名单验证中)",GOING="已发布",PAUSED="已暂停",ENDED="已结束"
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityStatusEnum
     */
    private String alipayActStatus;

    /**
     * 卡类型，CREDIT:信用卡,DEBIT:借记卡,DEBIT_CREDIT:借记卡或信用卡
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayBankCardTypeEnum
     */
    private String bankCardType;

    /**
     * 银行卡卡bin配置，列表类型,以逗号分隔的字符串数组
     */
    private String cardBinList;

    /**
     * 活动总预算值，以分为单位
     */
    private Long totalBudget;

    /**
     * 最少发放红包份数，比如：88代表此活动最少能发88次红包
     */
    private Long minSendCount;

    /**
     * 红包使用说明文案，类型String[]
     */
    private String userInstructionList;

    /**
     * 红包使用说明文案(可以自定义配置,默认使用userInstructionList)
     */
    private String userInstructionConfig;

    /**
     * 立减类型 reduce:满立减(满5元减3元) random:随机立减(满10元随机立减1元到3元
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayDiscountTypeEnum
     */
    private String discountType;

    /**
     * 优惠立减门槛金额 以分为单位
     */
    private Long discountThresholdAmt;

    /**
     * 优惠立减值, 分为单位如果discount_type=reduce，那么就是具体的优惠立减额，比如：999代表满足一定金额减9.99元；如果discount_type=random，那么就是"最小额-最大额"，比如:99-990，代表立减范围从0.99元到9.99元随机决策
     */
    private String discountValue;

    /**
     * 红包发放开始时间
     */
    private Date sendBeginTime;

    /**
     * 红包发放结束时间
     */
    private Date sendEndTime;

    /**
     * 代表限定周期时间类型 DAY_OF_WEEK:星期维度
     */
    private String cyclePeriodType;

    /**
     * 代表发放周期类型(cycle_period_type)下具体值。比如：cycle_period_type=DAY_OF_WEEK，cycle_period_value=["MON","TUE","WEB"],代表：周一、周二、周三
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayCyclePeriodTypeEnum
     */
    private String cyclePeriodValue;

    /**
     * 代表在周期时间范围下，子周期限定时间类型SECOND_OF_DAY:一天内具体时间点(秒为单位)
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipaySubCyclePeriodTypeEnum
     */
    private String subCyclePeriodType;

    /**
     * 代表发放周期类型(cycle_period_type)下具体值。比如：cycle_period_type=SECOND_OF_DAY，cycle_period_value=["01:53:28-02:53:28","05:10:10-08:30:30"],代表：子时间段为每天的01点53分28秒到02点53分28秒，05点10分10秒到08点30分30秒
     */
    private String subCyclePeriodValue;

    /**
     * 时间周期类型 ABSOLUTELY:绝对时间RELATIVE:相对时间
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayCouponAvailablePeriodTypeEnum
     */
    private String couponAvailablePeriodType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为ABSOLUTELY时，此处会有值 绝对时间情况下，红包发放开始时间
     */
    private Date couponAbsolutelyBeginTime;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为ABSOLUTELY时，此处会有值 绝对时间下红包发放结束时间
     */
    private Date couponAbsolutelyEndTime;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包发放开始时间周期类型 DAYS:天级 MINUTES:分钟级
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayCouponRelativeRoundingTypeEnum
     */
    private String couponRelativeBeginRoundingType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包开始时间相对值，比如:coupon_relative_begin_rounding_type=DAYS coupon_relative_begin_value=1 代表次日凌晨开始生效 比如:coupon_relative_begin_rounding_type=MINUTES coupon_relative_begin_value=100 代表当前时间100分钟后开始生效
     */
    private Long couponRelativeBeginValue;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包发放结束时间周期类型 DAYS:天级 MINUTES:分钟级
     *
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AlipayCouponRelativeRoundingTypeEnum
     */
    private String couponRelativeEndRoundingType;

    /**
     * 说明:当coupon_available_period_type不为空的时候且为RELATIVE时，此处会有值 相对时间情况下，红包开始时间相对值，比如:coupon_relative_end_rounding_type=MINUTES coupon_relative_end_value=100 代表从生效时间开始，有效期持续为100分钟
     */
    private Long couponRelativeEndValue;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人操作Id,ssoname
     */
    private String createOperatorName;

    /**
     * 需求主键, tb_demand.id
     */
    private Long demandId;

    /**
     * 采购商品主键, tb_purchase_goods.id
     */
    private Long demandGoodsId;

    /**
     * 商品规格ID
     */
    private Long skuId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 面额，单位分
     */
    private Long couponAmount;

    /**
     * 面额类型：1-固定，2-不固定
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 不固定面额：最小面额，单位分
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大面额，单位分
     */
    private Long rangeMaxAmount;


    /**
     * 是否启用，0-不启用，1启用
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer enableStatus;
}