package cn.com.duiba.quanyi.center.api.param.wx;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信下载记录
 * @author mybatis generator 
 * @date 2024-05-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxDownloadRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17158277158236614L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 起始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 下载状态 0-下载中 1-下载成功 2-下载失败 3-oss上传成功 4-存储完成
     */
    private Byte downloadStatus;

    /**
     * 账单原始文件oss地址
     */
    private String billOssUrl;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}