/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.wxcoupon;

import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.DiscountAmountRuleDto;
import cn.com.duiba.quanyi.center.api.utils.PriceUtils;
import cn.com.duiba.quanyi.center.api.utils.StringUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCouponAutoCreateUtils {
    private static final Logger log = LoggerFactory.getLogger(WxCouponAutoCreateUtils.class);
    private static final int ONE_WEEK_DAYS = 7;
    private static final String TIME_FORMAT_PATTERN = "^(?:[01]\\d|2[0-4]):[0-5]\\d$";

    public static Long calTotalAmount(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod, Integer dayReceiveLimit) {
        long twoWeeksAmount = budgetAmount / (long)WxCouponAutoCreateUtils.calDiffDays(startDate, endDate, stockDistributePeriod).intValue() * 14L;
        twoWeeksAmount += couponAmount - twoWeeksAmount % couponAmount;
        if (dayReceiveLimit == null) {
            return Math.min(Math.max(twoWeeksAmount, 10L * couponAmount), budgetAmount);
        }
        return Math.min(Math.max(Math.max(twoWeeksAmount, 10L * couponAmount), (long)dayReceiveLimit.intValue() * couponAmount), budgetAmount);
    }

    public static Integer calMaxNum(Long budgetAmount, Long couponAmount, String startDate, String endDate, Integer stockDistributePeriod, Integer dayReceiveLimit) {
        Long totalAmount = WxCouponAutoCreateUtils.calTotalAmount(budgetAmount, couponAmount, startDate, endDate, stockDistributePeriod, dayReceiveLimit);
        return Math.toIntExact((long)totalAmount.intValue() / couponAmount);
    }

    private static Integer calDiffDays(String startDate, String endDate, Integer stockDistributePeriod) {
        if (stockDistributePeriod != null) {
            return stockDistributePeriod;
        }
        return DateUtils.daysBetween((Date)DateUtils.getDayDate((String)startDate), (Date)DateUtils.getDayDate((String)endDate)) + 1;
    }

    public static boolean isValidStockName(String stockName) {
        return stockName != null && WxCouponAutoCreateUtils.strLength(stockName) <= 18;
    }

    private static int strLength(@NotBlank String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static boolean oneOrTwo(Integer num) {
        return num != null && (num == 1 || num == 2);
    }

    public static boolean zeroOrOne(Integer num) {
        return num != null && (num == 0 || num == 1);
    }

    public static boolean isValidThemeColor(Integer themeColor) {
        return themeColor != null && themeColor >= 1 && themeColor <= 10;
    }

    public static boolean isValidCardBin(@NotBlank String cardBinList) {
        List<String> cardBins = StringUtil.splitStringWithComma(cardBinList);
        if (cardBins.size() > 100) {
            return false;
        }
        for (String cardBin : cardBins) {
            if (cardBin.length() >= 6 && cardBin.length() <= 13) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBudgetAmount(String budgetAmount, Long discountAmount) {
        if (StringUtils.isBlank((CharSequence)budgetAmount)) {
            return false;
        }
        Long budget = PriceUtils.convertY2F(budgetAmount);
        return budget % discountAmount == 0L;
    }

    public static List<DiscountAmountRuleDto> parseDiscountAmountRules(String discountAmountRules) {
        if (StringUtils.isBlank((CharSequence)discountAmountRules)) {
            return null;
        }
        List<String> ruleStrList = StringUtil.splitStringWithComma(discountAmountRules);
        return ruleStrList.stream().map(ruleStr -> {
            DiscountAmountRuleDto dto = new DiscountAmountRuleDto();
            String[] ruleArr = ruleStr.split("&");
            if (ruleArr.length != 2) {
                log.info("parseDiscountAmountRules not valid ruleStr={}", ruleStr);
                return null;
            }
            dto.setAmount(PriceUtils.convertY2F(ruleArr[0]));
            String[] rangeArr = ruleArr[1].split("-");
            if (rangeArr.length != 2) {
                log.info("parseDiscountAmountRules not valid rangeArr={}", (Object)ruleArr[1]);
                return null;
            }
            dto.setStartRange(PriceUtils.convertY2F(rangeArr[0]));
            dto.setEndRange(PriceUtils.convertY2F(rangeArr[1]));
            return dto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Pair<Long, Long> getAmountRange(String discountAmountRules) {
        List<DiscountAmountRuleDto> ruleList = WxCouponAutoCreateUtils.parseDiscountAmountRules(discountAmountRules);
        if (CollectionUtils.isEmpty(ruleList)) {
            return Pair.of((Object)0L, (Object)0L);
        }
        long min = ruleList.stream().mapToLong(DiscountAmountRuleDto::getStartRange).min().orElse(0L);
        long max = ruleList.stream().mapToLong(DiscountAmountRuleDto::getEndRange).max().orElse(0L);
        return Pair.of((Object)min, (Object)max);
    }

    public static boolean isValidDiscountAmountRules(String discountAmountRules) {
        try {
            List<DiscountAmountRuleDto> ruleList = WxCouponAutoCreateUtils.parseDiscountAmountRules(discountAmountRules);
            if (CollectionUtils.isEmpty(ruleList) || ruleList.size() > 5) {
                log.info("isValidDiscountAmountRules not valid ruleList size is empty or more then 5 discountAmountRules={}", (Object)discountAmountRules);
                return false;
            }
            long totalNum = 0L;
            for (DiscountAmountRuleDto rule : ruleList) {
                long amount = rule.getAmount();
                Long startRange = rule.getStartRange();
                Long endRange = rule.getEndRange();
                if (amount <= 0L || startRange <= 0L || endRange <= 0L || endRange <= startRange || endRange >= amount) {
                    log.info("isValidDiscountAmountRules not valid amount startRange endRange is not valid discountAmountRule={}", (Object)JSON.toJSONString((Object)rule));
                    return false;
                }
                totalNum += amount / ((startRange + endRange) / 2L);
            }
            return totalNum >= 5L;
        }
        catch (Exception e) {
            log.error("isValidDiscountAmountRules discountAmountRules={}", (Object)discountAmountRules, (Object)e);
            return false;
        }
    }

    public static boolean isValidIrregularPeriod(String validTimeRange, String validTimePeriod) {
        if (StringUtils.isBlank((CharSequence)validTimeRange)) {
            log.warn("isValidIrregularPeriod validTimeRange is blank! validTimeRange={} validTimePeriod={}", (Object)validTimeRange, (Object)validTimePeriod);
            return false;
        }
        List<String> timeRanges = StringUtil.splitStringWithComma(validTimeRange);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(timeRanges)) {
            log.warn("isValidIrregularPeriod timeRanges is empty! validTimeRange={} validTimePeriod={}", (Object)validTimeRange, (Object)validTimePeriod);
            return false;
        }
        return WxCouponAutoCreateUtils.isValidTimePeriod(validTimePeriod);
    }

    public static boolean isValidRulePeriod(String validWeekDay, String validTimePeriod) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{validWeekDay, validTimePeriod})) {
            log.warn("isValidRulePeriod param is blank! validWeekDay={} validTimePeriod={}", (Object)validWeekDay, (Object)validTimePeriod);
            return false;
        }
        List<Integer> weekDays = StringUtil.splitIntegerWithComma(validWeekDay);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(weekDays) || weekDays.size() != 7) {
            log.warn("isValidRulePeriod validWeekDay is not valid! validWeekDay={}", (Object)validWeekDay);
            return false;
        }
        boolean mustSelectOne = weekDays.stream().anyMatch(weekDay -> weekDay == 1);
        if (!mustSelectOne) {
            log.warn("isValidRulePeriod validWeekDay is must select one! validWeekDay={}", (Object)validWeekDay);
            return false;
        }
        boolean zeroOrOne = weekDays.stream().allMatch(weekDay -> weekDay == 1 || weekDay == 0);
        if (!zeroOrOne) {
            log.warn("isValidRulePeriod validWeekDay is must zero or one! validWeekDay={}", (Object)validWeekDay);
            return false;
        }
        return WxCouponAutoCreateUtils.isValidTimePeriod(validTimePeriod);
    }

    private static boolean isValidTimePeriod(String validTimePeriod) {
        List<String> validTimePeriods = StringUtil.splitStringWithComma(validTimePeriod);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(validTimePeriods) || validTimePeriods.size() > 3) {
            log.warn("isValidTimePeriod validTimePeriods size must less 3! validTimePeriod={}", (Object)validTimePeriod);
            return false;
        }
        for (String timePeriod : validTimePeriods) {
            String[] split = StringUtils.split((String)timePeriod, (String)"-");
            if (split.length != 2) {
                log.warn("isValidTimePeriod validTimePeriods split size must less 2! validTimePeriod={}", (Object)validTimePeriod);
                return false;
            }
            if (WxCouponAutoCreateUtils.isValidTime(split[0]) && WxCouponAutoCreateUtils.isValidTime(split[1])) continue;
            log.warn("isValidTimePeriod validTimePeriods time not valid! validTimePeriod={}", (Object)validTimePeriod);
            return false;
        }
        return true;
    }

    private static boolean isValidTime(String time) {
        Pattern pattern = Pattern.compile(TIME_FORMAT_PATTERN);
        return pattern.matcher(time).matches();
    }

    public static void main(String[] args) {
        System.out.println(WxCouponAutoCreateUtils.isValidDiscountAmountRules("10&1-10,10&1-5"));
    }
}

