package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:30
 */
@Getter
@AllArgsConstructor
public enum InsuranceInstitutionFundBizTypeEnum {
    FUND_ADJUST(1, "资金调整"),
    EQUITY_SAVE(2, "新增权益"),
    EQUITY_EDIT(3, "编辑权益"),
    EQUITY_DELETED(4, "删除权益"),

    ADDITIONAL_EQUITY(5, "追加权益"),
    
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, InsuranceInstitutionFundBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceInstitutionFundBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceInstitutionFundBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
