package cn.com.duiba.quanyi.center.api.remoteservice.stock;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.stock.StoppedStockDownloadRecordDto;
import cn.com.duiba.quanyi.center.api.param.stock.StoppedStockDownloadRecordSearchParam;

import java.util.List;

/**
 * 批次已结束下载记录表
 * @author kjj mybatis generator 
 * @date 2024-06-04
 */
@AdvancedFeignClient
public interface RemoteStoppedStockDownloadRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 批次已结束下载记录集合
     */
    List<StoppedStockDownloadRecordDto> selectPage(StoppedStockDownloadRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(StoppedStockDownloadRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 批次已结束下载记录
     */
    StoppedStockDownloadRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 批次已结束下载记录
     * @return 执行结果
     */
    int insert(StoppedStockDownloadRecordDto dto);

    /**
     * 更新
     * @param dto 批次已结束下载记录
     * @return 影响行数
     */
    int update(StoppedStockDownloadRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量新增
     *
     * @param dtoList 参数
     * @return 结果
     */
    int batchInsert(List<StoppedStockDownloadRecordDto> dtoList);
}