package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeDto;

import java.util.List;
import java.util.Set;

/**
 * 活动奖品表
 *
 * @author kjj mybatis generator
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeService {
    /**
     * 新增
     *
     * @param activityPrizeDto 活动奖品
     * @return 执行结果
     */
    Long add(ActivityPrizeDto activityPrizeDto);


    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 活动奖品
     */
    ActivityPrizeDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 活动奖品列表
     */
    List<ActivityPrizeDto> selectByIds(Set<Long> ids);

    /**
     * 根据主键批量查询(包含已删除的)
     *
     * @param ids 主键集合
     * @return 活动奖品列表
     */
    List<ActivityPrizeDto> selectByIdsContainDelete(Set<Long> ids);

    /**
     * 更新
     *
     * @param activityPrizeDto 活动奖品
     * @return 执行结果
     */
    int update(ActivityPrizeDto activityPrizeDto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 根据活动id查询奖品列表
     *
     * @param activityId 活动id
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityId(Long activityId);

    /**
     * 根据活动id批量查询奖品列表
     *
     * @param activityIds 活动id
     * @return 活动奖品
     */
    List<ActivityPrizeDto> selectByActivityIds(Set<Long> activityIds);
}