package cn.com.duiba.quanyi.center.api.dto.coupon;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 核销通知表
 * @author mybatis generator 
 * @date 2024-02-04
 */
@Data
public class VerifyNotifyDto implements Serializable {
     
    private static final long serialVersionUID = 17070322814013440L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户名称
     */
    private String partnerName;

    /**
     * 场景类型,1:标准对接 2:银数定制对接
     */
    private Integer sceneType;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 状态是否启用, 0-停用, 1-启用
     */
    private Integer notifyStatus;

    /**
     * api对接ID
     */
    private Long apiJointId;

    /**
     * api对接名称
     */
    private String apiJointName;

    /**
     * 通知url
     */
    private String notifyUrl;

    /**
     * 关联客户ID
     */
    private Long partnerId;

    /**
     * 创建人操作Id,ssoid
     */
    private Long createOperatorId;

    /**
     * 创建人名称
     */
    private String createOperatorName;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     */
    private Integer logicDelete;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}