package cn.com.duiba.quanyi.center.api.param.mall.order;

import cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum;
import cn.com.duiba.quanyi.center.api.param.pay.ext.InsuranceFundCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import lombok.Data;

import java.io.Serializable;

/**
 * 商城支付创建订单参数
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class MallPayCreateOrderParam implements Serializable {
    
    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 配置ID
     */
    private Long confId;

    /**
     * 商城商品Id
     */
    private Long mallSpuId;

    /**
     * 商城商品Id
     */
    private Long mallSkuId;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * appId
     */
    private String appId;

    /**
     * 页面展示需要支付的金额
     */
    private Long pageAmount;

    /**
     * 支付渠道
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayChannelTypeEnum
     */
    private String payChannelType = PayChannelTypeEnum.WX_LITE.getChannelType();

    /**
     * 收货地址ID，实物时必填
     */
    private Long addressId;

    /**
     * 微信小程序支付参数
     */
    private WxLiteCreateOrderParam wxLite;

    /**
     * 保司资金账户
     */
    private InsuranceFundCreateOrderParam insuranceFund;
}
