/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.sm;

import cn.hutool.core.codec.Base62;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Util {
    private static final Logger log = LoggerFactory.getLogger(SM4Util.class);
    public static final String ALGORITHM_NAME = "SM4";
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final String ENCODING = "UTF-8";
    private static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";

    public static String generateKey() {
        return new String(Hex.toHexString((byte[])SM4Util.generateKey(128)));
    }

    private static byte[] generateKey(int keySize) {
        KeyGenerator kg;
        try {
            kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        }
        catch (Exception e) {
            log.error("generateKey error", (Throwable)e);
            throw new RuntimeException(e);
        }
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    private static Cipher generateEcbCipher(String algorithm, int mode, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance(algorithm, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
            cipher.init(mode, sm4Key);
            return cipher;
        }
        catch (Exception e) {
            log.error("generateEcbCipher error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] encryptEcbPadding(byte[] key, byte[] data) {
        Cipher cipher = SM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        try {
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            log.error("encryptEcbPadding", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] decryptEcbPadding(byte[] key, byte[] cipherText) {
        Cipher cipher = SM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        try {
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            log.error("decryptEcbPadding", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String encryptEcb(String hexKey, String data) {
        byte[] dataBytes;
        byte[] keyBytes = ByteUtils.fromHexString((String)hexKey);
        try {
            dataBytes = data.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            log.error("encryptEcb", (Throwable)e);
            throw new RuntimeException(e);
        }
        byte[] cipherBytes = SM4Util.encryptEcbPadding(keyBytes, dataBytes);
        return Base62.encode((byte[])cipherBytes);
    }

    public static String decryptEcb(String hexKey, String cipherBase62) {
        String data;
        byte[] keyBytes = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherBytes = Base62.decode((CharSequence)cipherBase62);
        byte[] srcBytes = SM4Util.decryptEcbPadding(keyBytes, cipherBytes);
        try {
            data = new String(srcBytes, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            log.error("decryptEcb", (Throwable)e);
            throw new RuntimeException(e);
        }
        return data;
    }

    public static void main(String[] args) {
        String key = SM4Util.generateKey();
        System.out.println("\u5bc6\u94a5:" + key);
        JSONObject data = new JSONObject();
        data.put("param1", (Object)"abc");
        data.put("param2", (Object)123456L);
        data.put("param3", (Object)"https://www.duiba.cn");
        String dataSrc = data.toJSONString();
        System.out.println("\u52a0\u5bc6\u524d\u539f\u6587:" + dataSrc);
        String bizData = SM4Util.encryptEcb(key, dataSrc);
        System.out.println("\u5bc6\u6587bizData\uff1a" + bizData);
        String deString = SM4Util.decryptEcb(key, bizData);
        System.out.println("\u89e3\u5bc6\u540e\u539f\u6587deString:" + deString);
        System.out.println("\u52a0\u89e3\u5bc6\u662f\u5426\u6210\u529f:" + Objects.equals(dataSrc, deString));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

