package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 上传任务业务类型
 * @author lizhi
 * @date 2023/3/29 2:13 PM
 */
@Getter
@AllArgsConstructor
public enum UploadBizTypeEnum {
    ACTIVITY_WHITE_LIST_ADD(1, "上传活动白名单"),
    ACTIVITY_STAFF_ADD(2, "上传活动客户经理"),
    ACTIVITY_PRIZE_USER_CONF_ADD(3, "上传活动奖项白名单"),
    CARD_SECRET_COUPON_CODE_ADD(4, "上传卡劵-劵码"),
    CARD_SECRET_COUPON_LINK_CODE_ADD(5, "上传卡劵-链接劵"),
    CARD_SECRET_COUPON_ACCOUNT_ADD(6, "上传卡劵-账号密码"),
    ICBC_SX_WRITE_OFF_ADD(7, "山西工行核销导入"),
    CCB_BUSINESS_IMPORT(8, "建行商户导入"),
    CCB_LN_SETTLEMENT_IMPORT(9, "辽宁建行结算明细导入"),
    INSURANCE_AGENT_IMPORT(10, "保司坐席导入"),
    INSURANCE_EQUITY_IMPORT(11, "保司车险权益导入"),
    INSURANCE_EQUITY_VERITY_IMPORT(12, "保单验真导入"),
    INSURANCE_EQUITY_HISTORY_IMPORT(13, "保单权益历史数据迁移导入"),
    ICBC_STORE_IMPORT(14, "工行门店导入"),
    COUPON_BANK_UPLOAD(15, "自动创建批次-银行立减金"),
    INSURANCE_RENBAO_EQUITY_IMPORT(16, "人保保司车险权益导入"),
    GOODS_ORDER_OBJECT_SHIP(17, "批量发货"),
    INSURANCE_NON_CAR_EQUITY_IMPORT(18, "保司非车权益导入"),
    INSURANCE_NON_CAR_RENBAO_EQUITY_IMPORT(19, "人保保司非车权益导入"),
    WX_COUPON_BILL_PULL(20, "微信账单拉取"),
    COUPON_FULL_UPLOAD(21, "自动创建微信立减金-全场代金券"),
    ICBC_SX_ACTIVITY_ADD(22, "山西工行活动导入"),
    INSURANCE_YUNYAN_EQUITY_IMPORT(23, "贵州云岩保司车险权益导入"),
    CASHIER_CUT_FULL_CUT_UPLOAD(24, "自动创建微信立减金-收银台全场立减"),
    CASHIER_CUT_FULL_DISCOUNT_UPLOAD(25, "自动创建微信立减金-收银台全场折扣"),
    CASHIER_DIRECT_CUT_UPLOAD(26, "自动创建微信立减金-收银台定向立减"),
    INSURANCE_CHANGSHA_EQUITY_IMPORT(27, "长沙保司车险权益导入"),
    PAYMENT_DETAIL_IMPORT(28, "打款明细上传"),
    WX_COUPON_UPLOAD_UPDATE(29, "微信立减金撒上传更新"),
    ACTIVITY_TEMPLATE_WHITE_IMPORT(31, "模板活动白名客户号单倒入"),
    WX_COUPON_MODIFY_AMOUNT_UPLOAD(32, "微信立减金批量修改金额导入"),
    INSURANCE_LAND_IMPORT(30, "大地保险权益导入"),
    ALIPAY_CARD_PAY_CUT_UPLOAD(33, "自动创建支付宝立减金-银行卡支付立减"),
    ALIPAY_GENERAL_COUPON_UPLOAD(34, "自动创建支付宝立减金-通用渠道红包"),
    ALIPAY_FIRST_BIND_UPLOAD(35, "自动创建支付宝立减金-首绑有礼"),
    ALIPAY_MANY_CARD_SWIPING_UPLOAD(36, "自动创建支付宝立减金-银行卡支付立减"),
    ACTIVITY_TEMPLATE_BASE_WHITE_IMPORT(37, "模板活动基础白名客户号单倒入"),
    BATCH_STOCK_UPLOAD_UPDATE(38, "批次号批量分配处理批次"),
    INSURANCE_EQUITY_CAR_SER_UPLOAD(39, "车服权益导入"),
    INSURANCE_BLACKLIST_UPLOAD(40, "保司黑名单导入"),
    ALIPAY_COUPON_UPLOAD_UPDATE(41, "支付宝立减金上传更新"),
    ALIPAY_ACTIVITY_UPLOAD(42, "自动创建支付宝活动"),
    INSURANCE_CHENGDUTAIBAO_EQUITY_IMPORT(43, "成都太保保司车险权益导入"),
    WX_COUPON_FIRST_BIND_UPLOAD(44, "自动创建微信立减金-首绑有礼"),
    PROJECT_GOODS_UPLOAD(45, "项目商品-批量导入"),
    CCB_HZ_SETTLEMENT_IMPORT(46, "杭州建行结算明细导入"),
    CCB_HZ_PAYMENT_IMPORT(47, "杭州建行打款记录明细导入"),
    JD_PAYMENT_ORDER_RECORD_IMPORT(48, "京东支付订单记录明细导入"),
    CQP_PAYMENT_ORDER_RECORD_IMPORT(49, "云闪付订单记录明细导入"),
    ALIPAY_DOLPHIN_PAYMENT_ORDER_RECORD_IMPORT(50, "支付宝海豚订单记录明细导入"),
    ICBC_DC_PAYMENT_ORDER_RECORD_IMPORT(51, "工行数币订单记录明细导入"),
    ABC_DC_PAYMENT_ORDER_RECORD_IMPORT(52, "农行数币订单记录明细导入"),
    DOU_YIN_PAYMENT_ORDER_RECORD_IMPORT(53, "抖音垫资订单记录明细导入"),
    INVOICE_UPLOAD(54, "批量上传发票"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
