package cn.com.duiba.quanyi.center.api.enums.project;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 项目权限类型
 * @date 2024/10/22
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ProjectAuthTypeEnum {
    BUSINESS_MANAGER(1, "商务负责人权限"),
    OPERATIONS_MANAGER(2, "运营负责人权限"),
    OPERATION(3, "运营权限"),
    ;

    private final Integer type;
    private final String desc;

    public static ProjectAuthTypeEnum getEnum(Integer type) {
        for (ProjectAuthTypeEnum item : ProjectAuthTypeEnum.values()) {
            if (item.getType().equals(type)) {
                return item;
            }
        }
        return null;
    }
}
