package cn.com.duiba.quanyi.center.api.dto.wx;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * WxFinancialCouponDto
 *
 * @author fmk
 * @since 2024/6/19
 */
@Data
public class WxCouponStatisticDto implements Serializable {

    private static final long serialVersionUID = 1200764251568436060L;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 批次号名称
     */
    private String stockName;

    /**
     * 配置日期
     */
    private Date configDate;

    /**
     * 公司名称：默认取该批次关联的公司主体(tb_partner.partner_subject)，不存在展示“-”，支持文件上传更新数据
     */
    private String companyName;

    /**
     * 结算主体：文本，上限50个字，默认为空，支持文件上传更新数据
     */
    private String settlementEntity;

    /**
     * 配置主体
     */
    private String configEntity;

    /**
     * 配置预算
     */
    private String configBudget;

    /**
     * 核销金额：默认展示截止当前的累计核销金额，筛选月份后展示当前周期的核销金额，支持按数字大小排序，T+2
     */
    private String verifiedAmount;

    /**
     * 退款金额：默认展示截止当前的累计退款金额，筛选月份后展示当前周期的退款金额，支持按数字大小排序，T+2
     */
    private String refundAmount;

    /**
     * 核销净额：默认展示截止当前的累计核销金额-累计退款金额，筛选月份后展示当前周期的核销金额-退款金额，支持按数字大小排序，T+2
     */
    private String netVerifiedAmount;

    /**
     * 余额（不含退款）：配置预算-核销金额，筛选月份后，为期间最后一天的配置预算-累计核销金额，T+2，支持按数字大小排序
     */
    private String balanceExcludingRefund;

    /**
     * 余额（含退款）：配置预算-核销金额+退款金额，筛选月份后，为期间最后一天的配置预算-累计核销金额+累积退款金额，T+2，支持按数字大小排序
     */
    private String balanceIncludingRefund;

    /**
     * 总应收账款：核销金额*结算价，筛选月份后为期间核销金额*结算价，支持按数字大小排序，T+2
     */
    private String totalReceivables;

    /**
     * 已打款金额：默认展示截止当前的累计已打款金额，筛选月份后展示当前周期的已打款金额，数据取自打款数据上传列表，支持按数字大小排序
     */
    private String paidAmount;

    /**
     * 运营负责人：默认取该批次的运营负责人，支持文件上传更新数据
     */
    private String operationManager;
}
