package cn.com.duiba.quanyi.center.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.order.MallOrderDto;
import cn.com.duiba.quanyi.center.api.param.mall.order.MallOrderSearchParam;
import java.util.List;

/**
 * 商城订单
 * @author kjj mybatis generator 
 * @date 2024-05-25
 */
@AdvancedFeignClient
public interface RemoteMallOrderService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商城订单集合
     */
    List<MallOrderDto> selectPage(MallOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MallOrderSearchParam param);

    /**
     * 分页查询用户支付成功的订单
     * @param userId 用户ID
     * @param lastId 上一次最后一个id，可为空
     * @param pageSize 每页条数
     * @return 商城订单集合
     */
    List<MallOrderDto> selectUserPaySuccessList(Long userId, Long lastId, Integer pageSize);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城订单
     */
    MallOrderDto selectById(Long id);

    /**
     * 根据订单编号查询
     * @param mallOrderNo 订单编号
     * @return 商城订单
     */
    MallOrderDto selectByMallOrderNo(String mallOrderNo);

    /**
     * 新增
     * @param dto 商城订单
     * @return 执行结果
     */
    int insert(MallOrderDto dto);

    /**
     * 更新
     * @param dto 商城订单
     * @return 影响行数
     */
    int update(MallOrderDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}