package cn.com.duiba.quanyi.center.api.dto.minsheng;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 民生银行用户兑换记录表
 *
 * @author mybatis generator
 * @date 2024-07-09
 */
@Data
public class MinshengConsumerExchangeRecordDto implements Serializable {

    private static final long serialVersionUID = 17205105164631288L;

    /**
     * 已兑换 0001
     */
    public static final int EXCHANGE = 1;
    /**
     * 取消订单 0010
     */
    public static final int CANCEL = 2;
    /**
     * 已下单 0100
     */
    public static final int ORDERED = 4;
    /**
     * 已配送 1000
     */
    public static final int DELIVERED = 8;
    /**
     * 已签收 10000
     */
    public static final int SIGNED = 16;

    /**
     * 主键
     */
    private Long id;

    /**
     * 员工用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 三方用户id
     */
    private String thirdUserId;

    /**
     * 银行订单号
     */
    private String bankOrderNo;

    /**
     * 卡券编号
     */
    private String couponCode;

    /**
     * 订单推送状态 默认状态0，无状态
     */
    private Integer pushStatus = 0;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 移除状态
     */
    public void removeStatus(Integer pushStatus) {
        this.pushStatus &= ~pushStatus;
    }

    /**
     * 添加状态
     */
    public void addStatus(Integer pushStatus) {
        this.pushStatus |= pushStatus;
    }

    /**
     * 检查是否有特定状态
     */
    public boolean hasStatus(Integer pushStatus) {
        return (this.pushStatus & pushStatus) != 0;
    }
}