package cn.com.duiba.quanyi.center.api.param.pay;

import cn.com.duiba.quanyi.center.api.enums.activity.PayChannelEnum;
import cn.com.duiba.quanyi.center.api.param.pay.ext.AlipayCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.CcbPayCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.MinshengPayCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.InsuranceFundCreateOrderParam;
import cn.com.duiba.quanyi.center.api.param.pay.ext.WxLiteCreateOrderParam;
import lombok.Data;

import java.io.Serializable;

/**
 * 活动支付创建订单参数
 *
 * @author lizhi
 * @date 2023/8/7 18:20
 */
@Data
public class PayCreateOrderParam implements Serializable {

    private static final long serialVersionUID = 8894539309360592962L;

    /**
     * 订单业务主键
     */
    private Long payBizId;

    /**
     * 订单业务类型, 1-白名单活动，2-商品包
     *
     * @see cn.com.duiba.quanyi.center.api.enums.pay.PayBizTypeEnum
     */
    private Integer payBizType;

    /**
     * 支付类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.PayChannelEnum
     */
    private Integer payChannel = PayChannelEnum.WX_PAY.getType();

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 支付商品名称
     */
    private String goodsName;

    /**
     * 微信小程序支付参数
     */
    private WxLiteCreateOrderParam wxLite;

    /**
     * 浙江建行支付参数
     */
    private CcbPayCreateOrderParam ccb;

    /**
     * 支付宝支付参数
     */
    private AlipayCreateOrderParam alipay;

    /**
     * 保司资金账户
     */
    private InsuranceFundCreateOrderParam insuranceFund;

    /**
     * 民生银行支付参数
     */
    private MinshengPayCreateOrderParam minshengPay;

    /**
     * appId
     */
    private String appId;
    /**
     * 活动ID
     */
    private Long activityId;
    /**
     * 活动类型
     */
    private Integer activityType;
}
