package cn.com.duiba.quanyi.center.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.user.CommonUserExtDto;

/**
 * 通用用户信息表
 * @author kjj mybatis generator 
 * @date 2024-06-03
 */
@AdvancedFeignClient
public interface RemoteCommonUserExtService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 通用用户信息
     */
    CommonUserExtDto selectById(Long id);


    /**
     * 根据用户主键查询
     * @param userId 主键
     * @return 通用用户信息
     */
    CommonUserExtDto selectByUserId(Long userId);

    /**
     * 新增
     * @param dto 通用用户信息
     * @return 执行结果
     */
    Long insert(CommonUserExtDto dto);

    /**
     * 更新
     * @param dto 通用用户信息
     * @return 影响行数
     */
    int update(CommonUserExtDto dto);

    /**
     * 根据用户唯一键+用户类型查询
     * @param thirdOnlyId 用户唯一号
     * @param userType 用户类型
     * @return 通用用户信息
     */
    CommonUserExtDto selectByOnlyIdAndType(String thirdOnlyId, Integer userType);
}