package cn.com.duiba.quanyi.center.api.dto.coupon;

import cn.com.duiba.quanyi.center.api.enums.qyrobot.QyRobotWxStockTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuzhigang
 * @date 2024/4/10 17:59
 **/
@Data
public class WxCouponAutoAddMoneyTaskDto implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 批次id
     */
    private String stockId;

    /**
     * 商户id
     */
    private String mchId;

    /**
     * 加款任务金额
     */
    private Long taskAmount;

    /**
     * 任务状态 1-加款中 2-加款成功 3-加款失败
     * {@link cn.com.duiba.quanyi.center.api.enums.coupon.WxCouponAddMoneyTaskStatusEnum}
     */
    private Integer taskStatus;

    /**
     * 类型 31-立减金 30-代金券
     * {@link QyRobotWxStockTypeEnum}
     */
    private String stockType;

    /**
     * 错误原因
     */
    private String errorMsg;

    /**
     * 每日发放上限金额
     */
    private Long dayAmount;

    /**
     * 加款前金额
     */
    private Long originAmount;

    /**
     * 每日发放上限数量
     */
    private Long dayLimitNum;

    /**
     * 自动加款类型 1-定时任务 2-实时触发 3-聚宝盆手动触发
     * {@link cn.com.duiba.quanyi.center.api.enums.coupon.WxCouponAutoAddMoneyTypeEnum}
     */
    private Integer addType;

    /**
     * 加款前剩余金额
     */
    private Long originSurplusAmount;
}
