package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 立减类型
 * reduce:满立减(满5元减3元)
 * random:随机立减(满10元随机立减1元到3元
 *
 * @see <a>https://opendocs.alipay.com/apis/07yvpj</>
 */
@Getter
@AllArgsConstructor
public enum AlipayDiscountTypeEnum {
    REDUCE("reduce", "满立减"),
    SINGLE("single", "定额立减(定额满减)"),
    discount("discount", "折扣立减"),
    RANDOM("random", "随机金额立减(随机满减)"),
    INTELLIGENT_ALGORITHM("intelligentAlgorithm", "智能立减"),
    MULTI_STAGED_DISCOUNT("multiStagedDiscount", "多阶梯立减"),
    ;

    private final String type;

    private final String desc;
}
