package cn.com.duiba.quanyi.center.api.param.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 订单查询入参（根据更新时间查终态的订单）
 *
 * @author wangguanhua
 */
@Data
public class GoodsOrderModifiedQueryParam implements Serializable {

    private static final long serialVersionUID = 1032380157886369640L;

    /**
     * 更新时间起始
     */
    private Date gmtModifiedStart;

    /**
     * 更新时间结束
     */
    private Date gmtModifiedEnd;

    /**
     * goods biz id
     */
    private Long goodsBizId;

    /**
     * goods biz type
     */
    private Integer goodsBizType;

    /**
     * 订单状态
     */
    private List<Integer> orderStatusList;

    /**
     * last id
     */
    private Long lastId;

    /**
     * page size
     */
    private Integer pageSize;
}