package cn.com.duiba.quanyi.center.api.param.common;

import cn.com.duiba.quanyi.center.api.enums.pkg.ChannelBizTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2024/7/9 14:04
 */
@Data
public class SpreadLinkAddParam implements Serializable {
    
    private static final long serialVersionUID = 5525422680517470935L;

    /**
     * 渠道ID
     */
    private Long channelBizId;

    /**
     * 渠道类型, 1-商品包
     *
     * @see ChannelBizTypeEnum
     */
    private Integer channelBizType;

    /**
     * 小程序appId
     */
    private String mpAppId;

    /**
     * 小程序跳转path，不带参数
     */
    private String mpPagePath;

    /**
     * 小程序基础参数（xx=xx&xx=xx&xx=xx格式）
     */
    private String mpBaseQuery;

    /**
     * 小程序h5落地地址，不带域名，可带额外参数
     */
    private String mpH5Path;

    /**
     * 多推广方式，统一拼接参数
     */
    private String baseQuery;

    /**
     * 公众号appId
     */
    private String oaAppId;

    /**
     * 公众号推广，落地页地址，不带域名，可带额外参数（不包含统一参数）
     */
    private String oaPath;

    /**
     * 普通h5推广，落地页地址，带域名，可带额外参数（不包含统一参数）
     */
    private String h5Path;

    /**
     * 需要初始化的渠道
     * @see cn.com.duiba.quanyi.center.api.enums.activity.VisitChannelTypeEnum
     */
    private List<Integer> initChannelTypeList;
    
}
