package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.activity.ActivityInviteAssistRecordDto;
import cn.com.duiba.quanyi.center.api.param.qy.activity.ActivityInviteAssistRecordSearchParam;

import java.util.List;

/**
 * 用户助力记录表
 * @author kjj mybatis generator 
 * @date 2024-06-20
 */
@AdvancedFeignClient
public interface RemoteActivityInviteAssistRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 用户助力记录集合
     */
    List<ActivityInviteAssistRecordDto> selectPage(ActivityInviteAssistRecordSearchParam param);

    /**
     * 查询时间范围内的助力记录
     * @param param 参数
     * @return 助力记录
     */
    List<ActivityInviteAssistRecordDto> getAssistRecordByTimeAndType(ActivityInviteAssistRecordSearchParam param);

    /**
     * 根据条件查询助力记录
     * @param activityId 活动ID
     * @param userId 用户ID
     * @return 用户邀请码集合
     */
    List<ActivityInviteAssistRecordDto> selectAssistRecord(Long activityId, Long userId);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityInviteAssistRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户助力记录
     */
    ActivityInviteAssistRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户助力记录
     * @return 执行结果
     */
    int insert(ActivityInviteAssistRecordDto dto);

    /**
     * 更新
     * @param dto 用户助力记录
     * @return 影响行数
     */
    int update(ActivityInviteAssistRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}