package cn.com.duiba.quanyi.center.api.remoteservice.goods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderCancelResultDto;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderDto;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderEsDto;
import cn.com.duiba.quanyi.center.api.dto.goods.GoodsOrderResultDto;
import cn.com.duiba.quanyi.center.api.param.order.GoodsOrderEsSearchParam;
import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum;
import cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderStatusEnum;
import cn.com.duiba.quanyi.center.api.param.order.GoodsOrderPageParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 商品库订单服务
 * @author lizhi
 * @date 2023/9/20 19:02
 */
@AdvancedFeignClient
public interface RemoteGoodsOrderService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 商品订单
     */
    GoodsOrderDto selectById(Long id);


    /**
     * 根据主键查询
     * @param idList 主键ID集合
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByIds(List<Long> idList);

    /**
     * 根据订单号批量查询
     * @param goodsOrderNos 订单号
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsOrderNos(Set<String> goodsOrderNos);

    /**
     * 批量查询商品订单
     * @param goodsBizType 商品库订单业务类型, 1-白名单活动，2-商品包
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     * @param goodsBizIds 商品库订单业务主键
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsBizIds(Integer goodsBizType, List<Long> goodsBizIds);

    /**
     * 查询结果
     * @param goodsOrderNo 商品库下单订单号
     * @return 结果
     */
    GoodsOrderResultDto getResult(String goodsOrderNo);

    /**
     * 根据订单号查询
     * @param goodsOrderNo 订单号
     * @return 商品订单
     */
    GoodsOrderDto selectByGoodsOrderNo(String goodsOrderNo);

    /**
     * 根据业务订单号和业务也行查询  mng后台查询使用
     * @param bizOrderNos
     * @param goodsBizType
     * @return
     */
    List<GoodsOrderDto> selectByBizOrderNoAndBizType(List<String> bizOrderNos, Integer goodsBizType);

    /**
     * 批量查询商品订单
     *
     * @param goodsBizType 商品库订单业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     * @param goodsBizId 商品库订单业务主键
     * @param bizOrderNoPrefix 业务单号前缀
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsBizNoPrefix(Integer goodsBizType, Long goodsBizId, String bizOrderNoPrefix);

    /**
     * 分页查询
     * @param goodsOrderPageParam
     * @return
     */
    List<GoodsOrderDto> selectPage(GoodsOrderPageParam goodsOrderPageParam);

    /**
     * 查询数量
     * @param goodsOrderPageParam
     * @return
     */
    Long selectCount(GoodsOrderPageParam goodsOrderPageParam);

    /**
     * 取消订单
     * @return
     */
    GoodsOrderCancelResultDto cancel(String goodsOrderNo, String cancelReason);

    /**
     * 批量查询商品订单
     *
     * @param goodsBizType 商品库订单业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     * @param goodsBizIds 商品库订单业务主键
     * @param bizOrderNos 业务单号
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByGoodsBizIdsNos(Integer goodsBizType, List<Long> goodsBizIds, List<String> bizOrderNos);

    /**
     * 根据订单号批量查询
     *
     * @param orderNos 订单号
     * @return 商品订单
     */
    List<GoodsOrderDto> selectByOrderNos(Set<String> orderNos);

    /**
     * 根据批量订单号及订单类型查询
     * @param batchOrderNos 批量订单号
     * @param goodsBizType 订单类型
     * @return 订单列表
     */
    List<GoodsOrderDto> selectByBatchOrderNos(Set<String> batchOrderNos, Integer goodsBizType);

    /**
     * 根据批量订单号及订单类型查询
     * @param batchOrderNo 批量订单号
     * @param goodsBizType 订单类型
     * @return 订单列表
     */
    List<GoodsOrderDto> selectByBatchOrderNo(String batchOrderNo, Integer goodsBizType);

    /**
     * 根据批量订单号及订单类型查询其中一个订单
     * @param batchOrderNo 批量订单号
     * @param goodsBizType 订单类型
     * @return 订单列表
     */
    GoodsOrderDto selectOneByBatchOrderNo(String batchOrderNo, Integer goodsBizType);

    /**
     * 根据条件搜索订单
     *
     * @param param 搜索条件
     * @return 订单实体
     */
    Pair<Long, List<GoodsOrderEsDto>> search(GoodsOrderEsSearchParam param);

    /**
     * 根据id查询订单
     *
     * @param id 订单id
     * @return 订单实体
     */
    GoodsOrderEsDto searchById(Long id);

    /**
     * 分页查询指定时间区间过期指定订单状态的订单
     *
     * @param startTime       start time
     * @param endTime         end time
     * @param goodsBizId      goods biz id
     * @param goodsBizType    goods biz type {@link GoodsOrderBizTypeEnum#getType()}
     * @param orderStatusList order status list {@link GoodsOrderStatusEnum#getStatus()}
     * @param lastId          last id
     * @param pageSize        page size
     * @return {@link List }<{@link GoodsOrderDto }>
     */
    List<GoodsOrderDto> selectPageByCouponExpireTime(Date startTime, Date endTime, Long goodsBizId, Integer goodsBizType, List<Integer> orderStatusList, Long lastId, Integer pageSize);

    /**
     * 分页查询指定时间区间更新指定订单状态的订单
     *
     * @param startTime       start time
     * @param endTime         end time
     * @param goodsBizId      goods biz id
     * @param goodsBizType    goods biz type {@link GoodsOrderBizTypeEnum#getType()}
     * @param orderStatusList order status list {@link GoodsOrderStatusEnum#getStatus()}
     * @param lastId          last id
     * @param pageSize        page size
     * @return {@link List }<{@link GoodsOrderDto }>
     */
    List<GoodsOrderDto> selectPageByUpdateTime(Date startTime, Date endTime, Long goodsBizId, Integer goodsBizType, List<Integer> orderStatusList, Long lastId, Integer pageSize);

}
