package cn.com.duiba.quanyi.center.api.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.payment.PaymentDetailDto;
import cn.com.duiba.quanyi.center.api.param.payment.PaymentDetailSearchParam;

import java.util.List;

/**
 * 打款明细表
 *
 * @author kjj mybatis generator
 * @date 2024-06-19
 */
@AdvancedFeignClient
public interface RemotePaymentDetailService {

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 打款明细集合
     */
    List<PaymentDetailDto> selectPage(PaymentDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(PaymentDetailSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 打款明细
     */
    PaymentDetailDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 打款明细
     * @return 执行结果
     */
    int insert(PaymentDetailDto dto);

    /**
     * 更新
     *
     * @param dto 打款明细
     * @return 影响行数
     */
    int update(PaymentDetailDto dto);

    /**
     * 物理删除
     *
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量新增
     *
     * @param dtoList 参数
     * @return 结果
     */
    int batchInsert(List<PaymentDetailDto> dtoList);

    /**
     * 根据偏移量查询
     *
     * @param param 查询参数
     * @return 结果
     */
    List<PaymentDetailDto> selectByOffset(PaymentDetailSearchParam param);

    /**
     * 查询列表(不分页)
     *
     * @param searchParam 查询参数
     * @return 结果
     */
    List<PaymentDetailDto> selectListNoPage(PaymentDetailSearchParam searchParam);

}