package cn.com.duiba.quanyi.center.api.enums.coupon;

import cn.com.duiba.quanyi.center.api.enums.pay.BankCardTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xuzhigang
 * @date 2024/3/26 10:42
 **/
@Getter
@AllArgsConstructor
public enum WxCouponBankTypeEnum {
    DEBIT(1, "借记卡"),
    CREDIT(2, "信用卡"),
    ;
    private final Integer bankType;

    private final String desc;

    public static boolean isValidType(Integer bankType) {
        return Arrays.stream(values()).anyMatch(t -> Objects.equals(t.getBankType(), bankType));
    }

    public static String convertBankType(Integer bankType) {
        if (Objects.equals(bankType, DEBIT.bankType)) {
            return BankCardTypeEnum.DEBIT.getType();
        }
        if (Objects.equals(bankType, CREDIT.bankType)) {
            return BankCardTypeEnum.CREDIT_DEBIT.getType();
        }
        return null;
    }
}
