package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/3/4 14:30
 */
@Getter
@AllArgsConstructor
public enum InsuranceFundBizTypeEnum {
    EQUITY_ADD(1, "权益新增"),
    EQUITY_EDIT(2, "权益编辑"),
    EQUITY_CHANGE_GRANT_PHONE(3, "变更发放账号"),
    EQUITY_DELETE(4, "权益编辑"),
    EQUITY_FIRST_GRANT(5, "权益一批次发放"),
    EQUITY_SECOND_GRANT(6, "权益二批次发放"),
    TAKE_EQUITY(7, "兑换"),
    PAY(8, "支付"),
    REFUND(9, "退款"),
    ADDITIONAL_EQUITY(10, "追加权益"),
    TAKE_REFUND(11, "兑换退回"),
    ;
    
    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, InsuranceFundBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InsuranceFundBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static InsuranceFundBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
