package cn.com.duiba.quanyi.center.api.param.activity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 秒杀活动领奖参数
 *
 * @author wangguanhua
 */
@Data
public class SeckillActivityTakePrizeParam implements Serializable {

    private static final long serialVersionUID = 2330269129076567036L;

    /**
     * 用户 id
     */
    Long userId;

    /**
     * 活动 id
     */
    Long activityId;

    /**
     * 秒杀场次开始时间
     */
    Date startTime;

    /**
     * 领取奖品 id
     */
    Long prizeId;

    /**
     * 领奖限制：1-限领一次，2-可领多次
     *
     * @see cn.com.duiba.quanyi.center.api.enums.activity.ActPrizeTakeNumLimitTypeEnum#getType()
     */
    private Integer takeNumLimitType;

    /**
     * 秒杀订单号
     */
    private String seckillOrderNo;
}
