package cn.com.duiba.quanyi.center.api.param.order;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 订单表
 * @author kjj mybatis generator
 * @date 2023-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class GoodsRetryOrderParam extends PageQuery {

    private static final long serialVersionUID = 5788497268156868660L;
    /**
     * 主键id
     */
    private Long id;

    /**
     * 异常和失败订单开始时间
     */
    private String exceptionAndFailStartTime;

    /**
     * 异常和失败订单结束时间
     */
    private String exceptionAndFailEndTime;

    /**
     * 处理中订单开始时间
     */
    private String processStartTime;

    /**
     * 处理中订单结束时间
     */
    private String processEndTime;

    /**
     * 商品库订单业务类型
     * @see cn.com.duiba.quanyi.center.api.enums.goods.GoodsOrderBizTypeEnum
     */
    private Integer goodsBizType;

    /**
     * 订单号
     */
    private String goodsOrderNo;
}