package cn.com.duiba.quanyi.center.api.remoteservice.activity;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityBatchTakeParamDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityPrizeReceiveResultDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityTakePrizeParamDto;
import cn.com.duiba.quanyi.center.api.dto.activity.BatchTakeResultDto;

/**
 * 活动奖品领取
 *
 * @author lizhi
 * @date 2023-08-07
 */
@AdvancedFeignClient
public interface RemoteActivityPrizeReceiveService {

    /**
     * 批量领取
     * @param dto 领取参数
     * @return 领取结果
     */
    BatchTakeResultDto batchTake(ActivityBatchTakeParamDto dto);

    /**
     * 异步领取奖品
     *
     * @param dto 参数
     * @return 结果
     */
    ActivityPrizeReceiveResultDto takePrize(ActivityTakePrizeParamDto dto);

    /**
     * 异步领取奖品
     *
     * @param receiveRecordId 领取记录表 id
     * @return 结果
     * @throws BizException biz exception
     */
    ActivityPrizeReceiveResultDto takePrizeByReceiveRecord(Long receiveRecordId) throws BizException;

    /**
     * 查询领奖结果
     *
     * @param activityType 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     * @param activityPrizeId 活动奖品ID
     * @param userId          用户ID
     * @return 结果
     * @deprecated 现在要支持多次领取，所以后续请用receiveResultWithTypeNum
     */
    @Deprecated
    ActivityPrizeReceiveResultDto receiveResultWithType(Integer activityType, Long activityPrizeId, Long userId);

    /**
     * 查询领奖结果
     *
     * @param activityType 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum
     * @param activityPrizeId 活动奖品ID
     * @param userId          用户ID
     * @param takeNum 第几次领取
     * @return 结果
     */
    ActivityPrizeReceiveResultDto receiveResultWithTypeNum(Integer activityType, Long activityPrizeId, Long userId, Integer takeNum);
}