package cn.com.duiba.quanyi.center.api.remoteservice.minsheng;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.minsheng.MinShengTakeAuthRecordDto;
import cn.com.duiba.quanyi.center.api.param.minsheng.MinShengTakeAuthRecordSearchParam;
import java.util.List;

/**
 * 民生银行用户兑换认证记录表
 * @author kjj mybatis generator 
 * @date 2024-07-04
 */
@AdvancedFeignClient
public interface RemoteMinShengTakeAuthRecordService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 民生银行用户兑换认证记录集合
     */
    List<MinShengTakeAuthRecordDto> selectPage(MinShengTakeAuthRecordSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MinShengTakeAuthRecordSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 民生银行用户兑换认证记录
     */
    MinShengTakeAuthRecordDto selectById(Long id);

    /**
     * 新增
     * @param dto 民生银行用户兑换认证记录
     * @return 执行结果
     */
    int insert(MinShengTakeAuthRecordDto dto);

    /**
     * 更新
     * @param dto 民生银行用户兑换认证记录
     * @return 影响行数
     */
    int update(MinShengTakeAuthRecordDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}