package cn.com.duiba.quanyi.center.api.enums.insurance;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author: LuHui
 * @date: 2024/6/28 14:27
 * @description:
 */
@Getter
@AllArgsConstructor
public enum InsuranceLandEquityGrantStatusEnum {

    WAIT(1, "待发放"),
    GRANT_FAIL(2, "发放前失败"),
    SUCCESS(3, "发放成功"),
    FAIL(4, "发放失败"),
    ;

    private final Integer status;

    private final String desc;

    public static InsuranceLandEquityGrantStatusEnum getByStatus(Integer status) {
        for (InsuranceLandEquityGrantStatusEnum statusEnum : InsuranceLandEquityGrantStatusEnum.values()) {
            if (Objects.equals(statusEnum.getStatus(), status)) {
                return statusEnum;
            }
        }
        return null;
    }


}
