package cn.com.duiba.quanyi.center.api.param.insurance;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 保单验真上传记录表
 * @author mybatis generator 
 * @date 2024-03-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InsuranceVerifyPolicyUploadRecordSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17103882268884053L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 操作人
     */
    private String createOperatorName;

    /**
     * 匹配成功行数
     */
    private Long matchNum;

    /**
     * 录入行数
     */
    private Long uploadNum;

    /**
     * 文件源下载路径
     */
    private String url;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 上传任务id
     * @see cn.com.duiba.quanyi.center.api.dto.common.UploadTaskDto id
     */
    private Long uploadTaskId;

    /**
     * 验真状态 0:未验真 1:已验真
     */
    private Integer verifyStatus;
}