package cn.com.duiba.quanyi.center.api.dto.mall.page;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 商城页面区域
 *
 * @author mybatis generator
 * @date 2024-05-23
 */
@Data
public class MallPageRegionDto implements Serializable {

    private static final long serialVersionUID = 17164468026922636L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 页面ID
     */
    private Long pageId;

    /**
     * 页面区域
     */
    private Integer pageRegion;

    /**
     * 页面区域状态，0-未启用 1-启用
     * {@link cn.com.duiba.quanyi.center.api.enums.mall.MallStatusEnum}
     */
    private Integer regionStatus;

    /**
     * 页面区域配置
     */
    private List<MallPageRegionConfDto> regionConfList;

    public String getUniqueKey() {
        return pageId + "_" + pageRegion;
    }
}