package cn.com.duiba.quanyi.center.api.dto.bank.zjbank;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 浙江建行核销明细表
 * @author mybatis generator 
 * @date 2024-07-19
 */
@Data
public class CcbZjHxBillDetailDto implements Serializable {
     
    private static final long serialVersionUID = 17213690243515592L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户活动类型
     */
    private String customActivityType;

    /**
     * 活动ID
     */
    private String activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 核销日期
     */
    private Date hxTime;

    /**
     * 红包核销面额（单位：分）
     */
    private Long hxAmount;

    /**
     * 订单金额（单位：分）
     */
    private Long orderAmount;

    /**
     * 实付金额（单位：分）
     */
    private Long payAmount;

    /**
     * 银行流水号
     */
    private String bankSerialNumber;

    /**
     * 支付宝交易号
     */
    private String alipayTransactionNumber;

    /**
     * 商家PID
     */
    private String merchantPid;

    /**
     * 商家名称
     */
    private String merchantName;

    /**
     * 预充值方式
     */
    private String preRechargeType;

    /**
     * 门店ID
     */
    private String storeId;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 券ID
     */
    private String couponId;

    /**
     * 券模板ID
     */
    private String couponTemplateId;

    /**
     * 卡号前6位
     */
    private String cardNumber;

    /**
     * 商圈名称
     */
    private String businessDistrictName;

    /**
     * 商圈门店名称
     */
    private String businessDistrictStoreName;

    /**
     * 账单日期（yyyy-MM-dd）
     */
    private LocalDate billDate;

    /**
     * 是否上传：0-未上传，1-已上传
     */
    private Byte bizStatus;

    /**
     * 额外信息
     */
    private String extra;
}