/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.utils.alipay;

import cn.com.duiba.quanyi.center.api.dto.coupon.autocreateext.alipay.AlipayActivityAutoCreateExtInfoDto;
import cn.com.duiba.quanyi.center.api.utils.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayActivityAutoCreateUtils {
    private static final Logger log = LoggerFactory.getLogger(AlipayActivityAutoCreateUtils.class);
    private static final String UNDERLINE = "_";

    public static List<AlipayActivityAutoCreateExtInfoDto.Bank> parseBankList(String bankListStr) {
        if (StringUtils.isBlank((CharSequence)bankListStr)) {
            return Collections.emptyList();
        }
        List<String> bankStrList = StringUtil.splitStringWithComma(bankListStr);
        return bankStrList.stream().map(AlipayActivityAutoCreateUtils::parseBank).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static AlipayActivityAutoCreateExtInfoDto.Bank parseBank(String bankStr) {
        List<String> bankNameAndBankCardType = StringUtil.splitStringWithSeparator(bankStr, UNDERLINE);
        if (CollectionUtils.isEmpty(bankNameAndBankCardType)) {
            return null;
        }
        AlipayActivityAutoCreateExtInfoDto.Bank bank = new AlipayActivityAutoCreateExtInfoDto.Bank();
        bank.setName(bankNameAndBankCardType.get(0));
        bank.setCardType(Integer.valueOf(bankNameAndBankCardType.get(1)));
        return bank;
    }
}

