package cn.com.duiba.quanyi.center.api.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author nongfu
 * @Date 2024/6/20 19:44
 */
@Getter
@AllArgsConstructor
public enum ActivityKvEnum {

    COMMON_DRAW_SP("common_draw_sp_%s_%s", "模板活动通用抽奖key"),
    COMMON_ASSIST_SP("common_assist_sp_%s_%s", "模板活动通用助力key"),
    SAVE_REGISTRATION("save_registration_%s_%s_%s", "湖南长沙活动报名记录"),
    HN_CZ_SAVE_REGISTRATION("hn_cz_save_registration_%s_%s_%s", "湖南郴州活动报名记录"),
    ACTIVITY_MONTH_DRAW_TAG("activity_month_draw_tag_%s_%s_%s", "活动每个周期领取一次"),
    COMMON_DRAW_EXPIRE_COUNT("draw_record_%s_%s_%s", "记录活动道具周期内消耗的次数"),
    ;

    private final String key;

    private final String desc;


    /**
     * 需要对应好否则会报错
     * @param key
     * @param args
     * @return
     */
    public static String getKey(String key, Object... args){
      return String.format(key, args);
    }

}
