package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author xuzhigang
 * @date 2024/3/25 16:32
 **/
@Getter
@AllArgsConstructor
public enum AlipayActivityAutoCreateTaskStatusEnum {

    INIT(0, "初始化"),

    CREATING(1, "创建中"),

    SUCCESS(2, "创建成功"),

    FAIL(3, "创建失败"),

    PUBLISH(4, "发布中"),

    PUBLISH_SUCCESS(5, "发布成功"),

    RELEASE_FAIL(6, "发布失败"),
    ;

    private final Integer taskStatus;

    private final String desc;

    public static boolean isEnd(Integer taskStatus) {
        return Objects.equals(taskStatus, SUCCESS.getTaskStatus()) || Objects.equals(taskStatus, FAIL.getTaskStatus());
    }

    private static final Map<Integer, AlipayActivityAutoCreateTaskStatusEnum> map = new HashMap<>();

    static {
        for (AlipayActivityAutoCreateTaskStatusEnum value : values()) {
            map.put(value.getTaskStatus(), value);
        }
    }

    public static String getDesc(Integer taskStatus) {
        AlipayActivityAutoCreateTaskStatusEnum value = map.get(taskStatus);
        if (value == null) {
            return "";
        }
        return value.getDesc();
    }
}
