package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityLimitConfigDto;

import java.util.List;
import java.util.Map;

/**
 * 活动白名单表
 *
 * @author lizhi
 * @date 2023/8/7 16:46
 */
@AdvancedFeignClient
public interface RemoteTemplateActivityService {

    /**
     * 校验是否命中活动限制
     * @param userId
     * @param activityId
     * @param prizeId
     * @return
     */
    Boolean checkLimitConfig(Long userId, Long activityId, Long prizeId);

    /**
     * 批量校验是否命中活动限制
     * @param userId 用户id
     * @param activityId 活动id
     * @param prizeIds 奖品id
     * @return 命中集合
     */
    Map<Long,Boolean> batchCheckLimitConfig(Long userId, Long activityId, List<Long> prizeIds);


    /**
     * 校验用户是否在领奖时间内
     * @param activityLimitConfigDto
     * @return
     */
    Boolean checkLimitDay(ActivityLimitConfigDto activityLimitConfigDto);

}
